#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'
require 'oci8'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative 'request_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/landing_appointments'
require_relative '../../pages/appointments/new_appointment_request'
require_relative '../../pages/appointments/request_appointment_detail'
require_relative '../../helper/modal'
require_relative '../../module/database/OracleUtility'
require_relative '../../module/DateUtility'
require_relative '../../helper/error_validation'
require_relative '../../module/database/MongoUtility'


describe '[Story # VAR-7833: Submit Request - Save to request db]
          [Story# VAR-10204: Save 5-digit location information when submitting an appointment request]' do
  include OracleUtility
  include DateUtility
  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing_appointments = LandingAppointments.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @modal = Modal.new(@driver)
    @new_request = NewAppointmentRequest.new(@driver)
    @detail = RequestAppointmentDetail.new(@driver)
    @error = Error_Validation.new(@driver)
    TITLE = "Appointments/Requests"

    #mongo
    @db = connectToMongoDB("var-utility")
    restoreCollection("siteSupportingVAR", "var-utility", "sites-supporting-var-exported2.json", @db)
    restoreCollection("clinical-services", "var-utility", "clinical_services_default.json", @db)
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name_brockton.json", @db)
    restoreCollection("requestEligibilityCriteria", "var-utility", "requestEligibilityCriteria.json", @db)
    restoreCollection("directBookingEligibilityCriteria", "var-utility", "directSchedulingEnabled.json", @db)

    @today = getDateNthDaysFromNow(0, "%m/%d/%Y")

    @fiveDaysLater = getDateNthDaysFromNow(5, "%m/%d/%Y")
    @nintyDaysLater = getDateNthDaysFromNow(90, "%m/%d/%Y")

    #this will not work in CI but the data will be reset in the jenkins
    @patientID = "1006088937V099668"
    @patientID2 = "1113138327"
    deletePatientData(@patientID)
    deletePatientData(@patientID2)
    @@locationID="523A5"
    @@locationName="BROCKTON VAMC"
    @@friendlyName ="Facility Friendly Brockton"
    @@bestTimeToCall = "Afternoon Evening"
    @desiredDateTime1 = [getDateNthDaysFromNow(40, "%m/%d/%Y"), "AM"]
    @desiredDateTime2 = [getDateNthDaysFromNow(42, "%m/%d/%Y"), "PM"]
    @desiredDAteTime3 = [getDateNthDaysFromNow(43, "%m/%d/%Y"), "AM"]
    @@new_message_50 = "01234567890123456789012345678901234567890123456789"
    @common.loginEndsOnHome(pw_redacted)
  end

  after(:all) do
    restoreCollection("custom-friendly-text", "var-utility", "facility_friendly_name.json", @db)
    @driver.close
  end

  context '[AC#: VAR-10196| TC#VAR-10197: Submit Request - Save to request db]
           [AC#VAR-10282| TC#VAR-10283: Save 5-digit location information when submitting an appointment request]' do

    it "Verify friendly name saved to db for new request" do

      typeOfCare = MENTAL_HEALTH
      schedulingMethod = "clerk"
      typeOfVisit = "Office Visit"
      purposeOfVisit = "Medication Concern"
      otherPurposeOfVisit = ""
      phoneNum = "(234) 567-8901"
      verifyPhoneNum = "(234) 567-8901"
      call_morning = false
      call_afternoon = true
      call_evening = true
      bestTimesForVAtoCall = [call_morning, call_afternoon, call_evening]
      vaToCallYou = true
      message = ""
      sendMeEmail = "false"
      email = "test1@hotmail.com"

      addRequest(schedulingMethod, typeOfCare, @@locationID, typeOfVisit, purposeOfVisit, otherPurposeOfVisit, @desiredDateTime1, @desiredDateTime2, @desiredDAteTime3, phoneNum, verifyPhoneNum, bestTimesForVAtoCall, vaToCallYou, message, sendMeEmail, email)
      "Preference: Call before booking appointment" + " Purpose of Visit: " + purposeOfVisit

      @common.waitWhileSpinnerPresent

      @detail.status_element.when_present(TIME_OUT_LIMIT)
      expect(@detail.has_expected_title?).to eq(true)

      expect(@detail.status_element.text).to eq("Status: Submitted")
      expect(@detail.status_desc_element.text).to eq("View status updates for this request under the \"Requests\" section of the Appointments and Requests page. Once scheduled, the resulting appointment will be displayed under the “Appointments” section of the same page.")

    end

    it "Verify submitted request details" do

      EXPECTED_TEXT = [\
        "Request Details",
        "Submitted: " + @today + " @HH:MM"   " Location: #{@@friendlyName} Type of Care: " + MENTAL_HEALTH  + " Preferred Type of Visit: " + "Office Visit",
        "Purpose of Visit: Medication Concern",
        "Preferred Appointment Date/Time",
        "1st Choice: " + @desiredDateTime1[0] + " " + @desiredDateTime1[1] + " 2nd Choice: " + @desiredDateTime2[0] + " " + @desiredDateTime2[1] + " 3rd Choice: " + @desiredDAteTime3[0] + " " + @desiredDAteTime3[1],
        "Your Contact Information",
        "Phone (234) 567-8901 Best Times for VA to Call #{@@bestTimeToCall}"
      ]

      actual_text = @detail.request_details_group_element.text.split("\n")
      EXPECTED_TEXT.each_with_index do | expectedScreenRow, i |
        if (expectedScreenRow.include?("Submitted:"))
          expect(actual_text[i]).to include("Submitted: " + @today)
          expect(actual_text[i]).to include("Location: #{@@friendlyName}")
        else
          expect(actual_text[i]).to eq(expectedScreenRow)
        end
      end

    end

    it "verify friendly name is saved in oracle" do
      sleep 2
      facilityData = executeAndGetDataAndNumRow("SELECT FACILITY_CODE, FRIENDLY_NAME FROM VARDB.APPOINTMENT_REQUEST WHERE PATIENT_ID = '1113138327' and STATUS ='Submitted'")
      facilityArr = facilityData.split("||")
      facilityArr = facilityArr[0].split(",")
      puts "Data is: ", facilityArr[0]
      expect(facilityArr[0]).to eq(@@locationID)
      expect(facilityArr[1]).to eq(@@friendlyName)

    end

    it "Verify Friendly name is displayed in request list" do
      button_element = @driver.button(:id => 'back-btn')
      @driver.execute_script("$(arguments[0]).click();",button_element)
      @common.waitWhileSpinnerPresent
      request_details = @landing_appointments.request_table_list_elements[0]
      request_details.scroll.to :top
      waitTillRequestsDisplay
      expect(@landing_appointments.getRequestTextForRowCol(1,3)).to eq("#{@@friendlyName}")
    end
  end

end
